/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Actor {
    static AnimData[] aniData = new AnimData[28];
    Actor actorReference;
    Anim anim = new Anim();
    byte objType;
    byte[] colBox = new byte[4];
    int[] V;
    int[] m_iInitV;
    long x;
    long y;
    short dx;
    short dy;
    short mmodel_type;
    short mmodel_vX;
    short mmodel_vY;
    short mmodel_aX;
    short mmodel_aY;
    short mmodel_fX;
    short mmodel_fY;
    short stateFlag;
    long m_lInitX;
    long m_lInitY;
    int m_iInitAction;
    short m_sInitStateFlag;
    byte[][] m_bPHBTable;
    short m_sPHBTableReferenceTileX;
    short m_sPHBTableReferenceTileY;
    short m_sTableRefIndexX;
    short m_sTableRefIndexY;
    boolean xDirectionConfirmed;
    int xDirectionConfirmationCounter;
    int yDirectionConfirmed;
    int yDirectionConfirmationCounter;
    int[] fist_time = new int[2];
    int fist_top = 0;
    static int[] fist_energy = new int[2];
    boolean bWasPHBStop;

    public Actor(byte[] data) {
        this.Actor_ctor(data);
        int nOff = 6;
        switch (this.objType) {
            case 0: {
                this.V = new int[17];
                this.V[1] = 0;
                this.V[12] = 0;
                this.V[0] = this.V[0] | 2;
                this.actorReference = null;
                this.m_bPHBTable = new byte[6][5];
                this.m_sPHBTableReferenceTileX = (short)-20;
                this.m_sPHBTableReferenceTileY = (short)-20;
                this.m_sTableRefIndexX = (short)2;
                this.m_sTableRefIndexY = (short)4;
                this.xDirectionConfirmed = true;
                break;
            }
            case 1: {
                this.stateFlag = (short)(this.stateFlag | 8);
                this.anim.newAction = 0;
                this.actorReference = null;
                break;
            }
            case 12: {
                this.V = new int[1];
                this.V[0] = 2;
                if (data[nOff++] == 0) break;
                this.anim.newAction = 5;
                break;
            }
            case 22: {
                this.V = new int[6];
                this.V[0] = data[nOff++] & 0xFF;
                this.V[1] = data[nOff++] & 0xFF;
                this.V[2] = data[nOff++] & 0xFF;
                this.V[2] = this.V[2] << 16;
                this.V[2] = this.V[2] | data[nOff++] & 0xFF;
                this.V[2] = this.V[2] | this.V[2] << 8;
                this.V[5] = data[nOff++] & 0xFF;
                this.V[3] = 240;
                this.V[4] = 0;
                break;
            }
            case 25: {
                this.stateFlag = (short)(this.stateFlag | 8);
                break;
            }
            case 10: 
            case 11: {
                this.V = new int[2];
                this.V[0] = data[nOff++];
                this.m_bPHBTable = new byte[1][1];
                this.m_sPHBTableReferenceTileX = (short)-10;
                this.m_sPHBTableReferenceTileY = (short)-10;
                this.m_sTableRefIndexX = 0;
                this.m_sTableRefIndexY = 0;
                break;
            }
            case 19: {
                this.V = new int[2];
                this.V[0] = 30;
                break;
            }
            case 7: {
                this.stateFlag = (short)(this.stateFlag | 2);
                break;
            }
            case 6: {
                this.V = new int[1];
                this.V[0] = data[nOff++] & 0xFF;
            }
        }
        if ((this.stateFlag & 2) != 0) {
            ++Game.s_iLeftToDie;
        }
        this.m_lInitX = this.x;
        this.m_lInitY = this.y;
        this.m_iInitAction = this.anim.newAction;
        this.m_sInitStateFlag = this.stateFlag;
        if (this.V != null) {
            this.m_iInitV = new int[this.V.length];
            System.arraycopy(this.V, 0, this.m_iInitV, 0, this.V.length);
        }
    }

    boolean GameObj_checkCollsion(Actor that) {
        if (that == null) {
            return false;
        }
        return this.GameObj_isCollideBox((int)((that.x >> 8) + (long)that.colBox[0]), (int)((that.y >> 8) + (long)that.colBox[1]), that.colBox[2] - that.colBox[0], that.colBox[3] - that.colBox[1]);
    }

    boolean GameObj_isCollideBox(int l, int t, int w, int h) {
        int me = (int)(this.x >> 8) + this.colBox[2];
        int it = l;
        if (me < it) {
            return false;
        }
        it = l + w;
        me = (int)(this.x >> 8) + this.colBox[0];
        if (it < me) {
            return false;
        }
        it = t + h;
        me = (int)(this.y >> 8) + this.colBox[1];
        if (it < me) {
            return false;
        }
        me = (int)(this.y >> 8) + this.colBox[3];
        it = t;
        return me >= it;
    }

    void MModel_Init(byte mmtype, short[] mmpar) {
        if (mmtype == 2) {
            return;
        }
        this.mmodel_type = mmtype;
        switch (this.mmodel_type) {
            case 0: {
                this.mmodel_vY = 0;
                this.mmodel_vX = 0;
                this.mmodel_aY = 0;
                this.mmodel_aX = 0;
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                this.mmodel_vX = mmpar[0];
                this.mmodel_vY = mmpar[1];
                break;
            }
            case 4: {
                this.mmodel_vX = mmpar[0];
                this.mmodel_vY = 0;
                break;
            }
            case 5: {
                this.mmodel_vY = mmpar[0];
                this.mmodel_vX = 0;
                break;
            }
            case 6: {
                this.mmodel_vX = mmpar[0];
                break;
            }
            case 7: {
                this.mmodel_vY = mmpar[0];
                break;
            }
            case 11: {
                this.mmodel_vX = mmpar[0];
                this.mmodel_vY = mmpar[1];
                this.mmodel_fX = mmpar[2];
                this.mmodel_aX = mmpar[3];
                this.mmodel_fY = mmpar[4];
                this.mmodel_aY = mmpar[5];
                this.mmodel_type = (short)8;
                break;
            }
            case 8: {
                this.mmodel_fX = mmpar[0];
                this.mmodel_aX = mmpar[1];
                this.mmodel_fY = mmpar[2];
                this.mmodel_aY = mmpar[3];
                break;
            }
            case 12: {
                this.mmodel_vX = mmpar[0];
                this.mmodel_fX = mmpar[1];
                this.mmodel_aX = mmpar[2];
                this.mmodel_type = (short)9;
                break;
            }
            case 9: {
                this.mmodel_fX = mmpar[0];
                this.mmodel_aX = mmpar[1];
                break;
            }
            case 13: {
                this.mmodel_vY = mmpar[0];
                this.mmodel_fY = mmpar[1];
                this.mmodel_aY = mmpar[2];
                this.mmodel_type = (short)10;
                break;
            }
            case 10: {
                this.mmodel_fY = mmpar[0];
                this.mmodel_aY = mmpar[1];
            }
        }
    }

    void MModel_Tick() {
        if ((this.mmodel_type == 8 || this.mmodel_type == 9) && this.mmodel_aX != 0) {
            this.mmodel_vX = (short)(this.mmodel_vX + this.mmodel_aX);
            if (this.mmodel_fX > 0 && this.mmodel_vX > this.mmodel_fX || this.mmodel_fX < 0 && this.mmodel_vX < this.mmodel_fX) {
                this.mmodel_vX = this.mmodel_fX;
                this.mmodel_aX = 0;
            }
        }
        if ((this.mmodel_type == 8 || this.mmodel_type == 10) && this.mmodel_aY != 0) {
            this.mmodel_vY = (short)(this.mmodel_vY + this.mmodel_aY);
            if (this.mmodel_fY > 0 && this.mmodel_vY > this.mmodel_fY || this.mmodel_fY < 0 && this.mmodel_vY < this.mmodel_fY) {
                this.mmodel_vY = this.mmodel_fY;
                this.mmodel_aY = 0;
            }
        }
    }

    static void AniLoad(int aniResIndex, int resID) {
        int size;
        AnimData data;
        byte[] buffer = Game.RM_Array_Data[aniResIndex];
        if (buffer == null) {
            return;
        }
        int type = buffer[0] & 0x7F;
        if (aniData[type] != null) {
            Actor.aniData[type].flag = (byte)(Actor.aniData[type].flag | 2);
            return;
        }
        Actor.aniData[type] = data = new AnimData();
        data.resID = (byte)resID;
        data.flag = (byte)((buffer[0] & 0x80) != 0 ? 1 : 0);
        data.nbModule = buffer[1];
        data.nbFrame = buffer[2];
        data.nbAction = buffer[3];
        data.flag = (byte)(data.flag | 2);
        int count = data.nbModule & 0xFF;
        data.modules = new byte[count][];
        int offset = 4;
        int i = 0;
        while (i < count) {
            data.modules[i] = new byte[4];
            System.arraycopy(buffer, offset, data.modules[i], 0, 4);
            offset += 4;
            ++i;
        }
        count = data.nbFrame & 0xFF;
        data.frames = new byte[count][];
        int i2 = 0;
        while (i2 < count) {
            size = 6 + 3 * (buffer[offset + 0] & 0xFF);
            data.frames[i2] = new byte[size];
            System.arraycopy(buffer, offset, data.frames[i2], 0, size);
            offset += size;
            ++i2;
        }
        count = data.nbAction & 0xFF;
        data.actions = new byte[count][];
        data.mmParam = new byte[count][];
        int i3 = 0;
        while (i3 < count) {
            size = 1 + (buffer[offset + 0] & 0xFF);
            data.actions[i3] = new byte[size];
            System.arraycopy(buffer, offset, data.actions[i3], 0, size);
            offset += size;
            size = 1 + (buffer[offset + 0] & 0xF);
            data.mmParam[i3] = new byte[size];
            System.arraycopy(buffer, offset, data.mmParam[i3], 0, size);
            offset += size;
            ++i3;
        }
    }

    boolean Ani_CheckEnd() {
        if (this.anim.newAction != this.anim.curAction) {
            return false;
        }
        return this.anim.frameTick + 1 >= this.anim.frameDuration && this.anim.actionFrame + 1 >= Actor.aniData[this.anim.type].actions[this.anim.newAction][0];
    }

    static void drawModule(AnimData pData, int idMod, int nx, int ny, int nflag, Graphics g) {
        byte[] modules = pData.modules[idMod];
        GameMidlet.Instance_Game.drawImageEx(nx, ny, modules[2] & 0xFF, modules[3] & 0xFF, pData.resID, modules[0] & 0xFF, modules[1] & 0xFF, nflag);
    }

    void step() {
        this.x += (long)this.dx;
        this.y += (long)this.dy;
        Anim.aniEvent_flag = 0;
        this.anim.step(true);
        if ((Anim.aniEvent_flag & 1) != 0) {
            this.MModel_Init(Anim.aniEvent_mmtype, Anim.aniEvent_mmpar);
            this.stateFlag = (short)(this.stateFlag | 0x10);
        }
        if ((Anim.aniEvent_flag & 2) != 0) {
            if ((this.stateFlag & 1) != 0) {
                this.colBox[0] = -Anim.aniEvent_pColBoxData[2];
                this.colBox[2] = -Anim.aniEvent_pColBoxData[0];
            } else {
                this.colBox[0] = Anim.aniEvent_pColBoxData[0];
                this.colBox[2] = Anim.aniEvent_pColBoxData[2];
            }
            if ((this.stateFlag & 4) != 0) {
                this.colBox[1] = -Anim.aniEvent_pColBoxData[3];
                this.colBox[3] = -Anim.aniEvent_pColBoxData[1];
            } else {
                this.colBox[1] = Anim.aniEvent_pColBoxData[1];
                this.colBox[3] = Anim.aniEvent_pColBoxData[3];
            }
        }
        this.dx = (this.stateFlag & 0x10) != 0 && (this.stateFlag & 1) != 0 ? (short)(-this.mmodel_vX) : this.mmodel_vX;
        this.dy = (this.stateFlag & 0x10) != 0 && (this.stateFlag & 4) != 0 ? (short)(-this.mmodel_vY) : this.mmodel_vY;
        if ((this.stateFlag & 0x10) != 0) {
            this.MModel_Tick();
        }
    }

    void draw() {
        if (this.objType == 0 && (this.V[1] & 1) == 1 || this.objType == 22 && (this.V[4] & 1) == 1) {
            Game.raymanDraw = 2;
            return;
        }
        if (this.objType == 0) {
            Game.raymanNull = this.anim.frameId;
        }
        this.anim.draw((int)(this.x >> 8), (int)(this.y >> 8), this.stateFlag & 5);
        if (this.objType == 0) {
            Game.raymanDraw = (int)(this.y >> 8);
        }
    }

    void Actor_ctor(byte[] data) {
        this.objType = data[1];
        this.x = Game.ReadUnsignedShort(data, 2);
        this.x *= 2L;
        this.x <<= 8;
        this.y = Game.ReadUnsignedShort(data, 4);
        this.y *= 2L;
        this.y <<= 8;
        short firstAction = (short)(data[0] & 0xF);
        this.stateFlag = (short)((data[0] & 0xF0) >> 4);
        this.mmodel_vY = 0;
        this.mmodel_vX = 0;
        this.mmodel_aY = 0;
        this.mmodel_aX = 0;
        this.mmodel_fY = 0;
        this.mmodel_fX = 0;
        Anim.aniEvent_flag = 0;
        this.anim.build(this.objType, firstAction);
        if ((Anim.aniEvent_flag & 1) != 0) {
            this.MModel_Init(Anim.aniEvent_mmtype, Anim.aniEvent_mmpar);
            this.stateFlag = (short)(this.stateFlag | 0x10);
        }
        if ((Anim.aniEvent_flag & 2) != 0) {
            if ((this.stateFlag & 1) != 0) {
                this.colBox[0] = -Anim.aniEvent_pColBoxData[0];
                this.colBox[2] = -Anim.aniEvent_pColBoxData[2];
            } else {
                this.colBox[0] = Anim.aniEvent_pColBoxData[0];
                this.colBox[2] = Anim.aniEvent_pColBoxData[2];
            }
            if ((this.stateFlag & 4) != 0) {
                this.colBox[1] = -Anim.aniEvent_pColBoxData[1];
                this.colBox[3] = -Anim.aniEvent_pColBoxData[3];
            } else {
                this.colBox[1] = Anim.aniEvent_pColBoxData[1];
                this.colBox[3] = Anim.aniEvent_pColBoxData[3];
            }
        }
        this.dx = 0;
        this.dy = 0;
    }

    boolean checkFloor() {
        if (this.dy < 0) {
            return false;
        }
        int tilePosX = (int)(this.x + (long)this.dx >> 8 >> 4);
        int tilePosY = (int)(this.y + (long)this.dy >> 8 >> 4);
        byte phb = this.Actor_GetPHB(tilePosX, tilePosY);
        if (phb == 0 && (phb = this.Actor_GetPHB(tilePosX, tilePosY = (int)(this.y + (long)this.dy + (long)Math.abs(this.dx) >> 8 >> 4))) == 0) {
            return false;
        }
        boolean bHasTouchedFloor = false;
        this.bWasPHBStop = false;
        while (phb == 1 || phb == 31) {
            bHasTouchedFloor = true;
            this.dy = (short)((long)(tilePosY << 8 << 4) - this.y);
            if ((phb = this.Actor_GetPHB(tilePosX, --tilePosY)) != 28) continue;
            this.bWasPHBStop = true;
        }
        if (phb == 2 || phb >= 4 && phb <= 9) {
            int displacement = GameMidlet.Instance_Game.PF_getSlopeDisp(phb, (int)((this.x + (long)this.dx >> 8 & 0xFL) / 2L));
            this.dy = (short)((long)((tilePosY << 8 << 4) + displacement * 2) - this.y);
            return true;
        }
        return bHasTouchedFloor;
    }

    boolean checkWall() {
        int tileUpperPosY;
        byte colBoxSide = this.dx <= 0 ? this.colBox[0] : this.colBox[2];
        int tilePosX = (int)(this.x + (long)this.dx >> 8) + colBoxSide >> 4;
        int tileLowerPosY = (int)(this.y + (long)this.dy >> 8) + this.colBox[3] - 1 >> 4;
        int i = tileUpperPosY = (int)(this.y + (long)this.dy >> 8) + this.colBox[1] + 1 >> 4;
        while (i <= tileLowerPosY) {
            byte phb = this.Actor_GetPHB(tilePosX, i);
            if (phb == 1 || phb == 31) {
                phb = this.dx < 0 ? this.Actor_GetPHB(tilePosX + 1, i) : this.Actor_GetPHB(tilePosX - 1, i);
                if (this.dx < 0) {
                    int otherSideTilePosX = (int)(this.x + (long)this.dx >> 8) + this.colBox[2] >> 4;
                    int j = tilePosX;
                    while (j < otherSideTilePosX) {
                        phb = this.Actor_GetPHB(j + 1, i);
                        if (phb == 2 || phb >= 4 && phb <= 9) {
                            return false;
                        }
                        ++j;
                    }
                } else {
                    int otherSideTilePosX;
                    int j = otherSideTilePosX = (int)(this.x + (long)this.dx >> 8) + this.colBox[0] >> 4;
                    while (j > tilePosX) {
                        phb = this.Actor_GetPHB(j - 1, i);
                        if (phb == 2 || phb >= 4 && phb <= 9) {
                            return false;
                        }
                        --j;
                    }
                }
                this.dx = (short)(16 - (char)((this.x >> 8) + (long)colBoxSide - (long)(tilePosX << 4)) << 8);
                return true;
            }
            ++i;
        }
        return false;
    }

    void Spike_ai() {
        int action = this.anim.curAction;
        switch (action) {
            case 0: {
                int f = 0;
                while (f < 2) {
                    if (Game.pFist[f].Fist_CheckCollision(this)) {
                        this.anim.newAction = 1;
                        break;
                    }
                    ++f;
                }
                if (!this.GameObj_checkCollsion(Game.pRayman)) break;
                Game.pRayman.doDamage();
                break;
            }
            case 1: {
                if (this.Ani_CheckEnd() && (Game.pFist[0].stateFlag & 8) != 0 && (Game.pFist[1].stateFlag & 8) != 0) {
                    this.anim.newAction = 0;
                }
                if (!this.GameObj_checkCollsion(Game.pRayman)) break;
                Game.pRayman.doDamage();
            }
        }
    }

    void Bomb_ai() {
        int action = this.anim.curAction;
        block0 : switch (action) {
            case 0: {
                if (this.GameObj_checkCollsion(Game.pRayman)) {
                    Game.pRayman.doDamage();
                    this.anim.newAction = 1;
                }
                int f = 0;
                while (f < 2) {
                    if (Game.pFist[f].Fist_CheckCollision(this)) {
                        this.anim.newAction = 1;
                        GameMidlet.Instance_Game.PlaySound(26, true);
                        break block0;
                    }
                    ++f;
                }
                break;
            }
            case 1: {
                if (!this.Ani_CheckEnd()) break;
                this.stateFlag = (short)(this.stateFlag | 8);
            }
        }
    }

    void SeaUrchin_ai() {
        int action = this.anim.curAction;
        switch (action) {
            case 0: {
                int f = 0;
                while (f < 2) {
                    if (Game.pFist[f].Fist_CheckCollision(this)) {
                        this.anim.newAction = 1;
                        break;
                    }
                    ++f;
                }
                if (!this.GameObj_checkCollsion(Game.pRayman)) break;
                Game.pRayman.doDamage();
                break;
            }
            case 1: {
                if (this.Ani_CheckEnd()) {
                    this.anim.newAction = 0;
                }
                if (!this.GameObj_checkCollsion(Game.pRayman)) break;
                Game.pRayman.doDamage();
            }
        }
    }

    void Tentacle_ai() {
        int action = this.anim.curAction;
        block0 : switch (action) {
            case 0: 
            case 1: {
                this.V[1] = this.V[1] + 1;
                if (this.V[1] <= this.V[0] || Math.abs(Game.pRayman.x - this.x) >= 30720L || Math.abs(Game.pRayman.y - this.y) >= 40960L) break;
                if (action == 1) {
                    this.anim.newAction = 5;
                    break;
                }
                this.anim.newAction = 2;
                break;
            }
            case 2: 
            case 5: {
                if (this.GameObj_checkCollsion(Game.pRayman)) {
                    Game.pRayman.doDamage();
                }
                int f = 0;
                while (f < 2) {
                    if (Game.pFist[f].Fist_CheckCollision(this)) {
                        this.anim.newAction = action == 5 ? 7 : 4;
                        this.V[1] = 0;
                        break;
                    }
                    ++f;
                }
                if (!this.Ani_CheckEnd()) break;
                if (action == 5) {
                    this.anim.newAction = 6;
                    break;
                }
                this.anim.newAction = 3;
                break;
            }
            case 3: 
            case 6: {
                if (this.GameObj_checkCollsion(Game.pRayman)) {
                    Game.pRayman.doDamage();
                }
                int f = 0;
                while (f < 2) {
                    if (Game.pFist[f].Fist_CheckCollision(this)) {
                        this.V[1] = 0;
                        this.anim.newAction = action == 6 ? 7 : 4;
                        GameMidlet.Instance_Game.PlaySound(26, true);
                        break block0;
                    }
                    ++f;
                }
                break;
            }
            case 4: 
            case 7: {
                if (!this.Ani_CheckEnd()) break;
                this.anim.newAction = action == 7 ? 1 : 0;
            }
        }
    }

    void Fly_ai() {
        int action = this.anim.curAction;
        block0 : switch (action) {
            case 0: {
                if (this.GameObj_checkCollsion(Game.pRayman)) {
                    Game.pRayman.doDamage();
                }
                int f = 0;
                while (f < 2) {
                    if (Game.pFist[f].Fist_CheckCollision(this)) {
                        this.anim.newAction = 2;
                        GameMidlet.Instance_Game.PlaySound(26, true);
                        break;
                    }
                    ++f;
                }
                if (Math.abs(Game.pRayman.x - this.x) >= 30720L || Math.abs(Game.pRayman.y - this.y) >= 20480L) break;
                this.anim.newAction = 1;
                this.mmodel_vX = (short)((Game.pRayman.x - this.x) / 32L);
                this.mmodel_vY = (short)((Game.pRayman.y - this.y) / 32L);
                break;
            }
            case 1: {
                if (this.GameObj_checkCollsion(Game.pRayman)) {
                    Game.pRayman.doDamage();
                }
                int f = 0;
                while (f < 2) {
                    if (Game.pFist[f].Fist_CheckCollision(this)) {
                        this.anim.newAction = 2;
                        GameMidlet.Instance_Game.PlaySound(26, true);
                        break block0;
                    }
                    ++f;
                }
                break;
            }
            case 2: {
                if (!this.Ani_CheckEnd()) break;
                this.stateFlag = (short)(this.stateFlag | 8);
            }
        }
    }

    void Bonus_ai() {
        if (this.objType == 9) {
            int f = 0;
            while (f < 2) {
                Actor pFist = Game.pFist[f];
                if ((pFist.stateFlag & 8) == 0 && this.GameObj_checkCollsion(pFist)) {
                    Game.pFist[0].stateFlag = (short)(Game.pFist[0].stateFlag | 8);
                    Game.pFist[1].stateFlag = (short)(Game.pFist[1].stateFlag | 8);
                    this.fist_top = 0;
                    Game.pFist[0].anim.curAction = 0;
                    Game.pFist[1].anim.curAction = 0;
                    Game.pRayman.actorReference = null;
                    Game.pRayman.anim.newAction = 27;
                    Game.pRayman.step();
                    Game.pRayman.x = this.x;
                    Game.pRayman.y = this.y;
                    Game.pRayman.V[13] = (int)this.x >> 8;
                    Game.pRayman.V[14] = (int)this.y >> 8;
                }
                ++f;
            }
        } else if (this.GameObj_checkCollsion(Game.pRayman)) {
            this.stateFlag = (short)(this.stateFlag | 8);
            switch (this.objType) {
                case 2: {
                    ++Game.s_iLumsTaken;
                    Game.Status_Show(2);
                    GameMidlet.Instance_Game.PlaySound(28, true);
                    break;
                }
                case 3: {
                    Game.m_gameFrame_nLife = (byte)(Game.m_gameFrame_nLife + (Game.m_gameFrame_nLife < 99 ? (byte)1 : 0));
                    Game.Status_Show(0);
                    GameMidlet.Instance_Game.PlaySound(30, true);
                    break;
                }
                case 5: {
                    Game.m_gameFrame_nEnergy = (byte)(Game.m_gameFrame_nEnergy + (Game.m_gameFrame_nEnergy < 5 ? (byte)1 : 0));
                    Game.Status_Show(0);
                    GameMidlet.Instance_Game.PlaySound(29, true);
                    break;
                }
                case 4: {
                    Game.pRayman.V[7] = -1;
                    Game.pRayman.anim.newAction = 9;
                    GameMidlet.Instance_Game.PlaySound(28, true);
                    break;
                }
                case 24: {
                    Game.s_actorCheckpoint = this;
                    GameMidlet.Instance_Game.PlaySound(28, true);
                }
            }
        }
    }

    void Cage_ai() {
        int action = this.anim.curAction;
        block0 : switch (action) {
            case 0: {
                int f = 0;
                while (f < 2) {
                    if (Game.pFist[f].anim.curAction == 1 && Game.pFist[f].Fist_CheckCollision(this)) {
                        GameMidlet.Instance_Game.PlaySound(24, true);
                        this.anim.newAction = 2;
                        break block0;
                    }
                    ++f;
                }
                break;
            }
            case 2: {
                if (!this.Ani_CheckEnd()) break;
                this.V[0] = this.V[0] - 1;
                if (this.V[0] != 0) {
                    this.anim.newAction = 0;
                    break;
                }
                GameMidlet.Instance_Game.PlaySound(23, true);
                ++Game.s_iCageOpened;
                this.anim.newAction = 4;
                Game.Status_Show(1);
                break;
            }
            case 4: {
                if (!this.Ani_CheckEnd() && GameMidlet.Instance_Game.Camera_IsVisible(this)) break;
                this.stateFlag = (short)(this.stateFlag | 8);
                break;
            }
            case 5: {
                int f = 0;
                while (f < 2) {
                    if (Game.pFist[f].anim.curAction == 1 && Game.pFist[f].Fist_CheckCollision(this)) {
                        GameMidlet.Instance_Game.PlaySound(24, true);
                        this.anim.newAction = 7;
                        break block0;
                    }
                    ++f;
                }
                break;
            }
            case 7: {
                if (!this.Ani_CheckEnd()) break;
                this.V[0] = this.V[0] - 1;
                if (this.V[0] != 0) {
                    this.anim.newAction = 5;
                    break;
                }
                GameMidlet.Instance_Game.PlaySound(23, true);
                ++Game.s_iCageOpened;
                this.anim.newAction = 9;
                Game.Status_Show(1);
                break;
            }
            case 9: {
                if (!this.Ani_CheckEnd() && GameMidlet.Instance_Game.Camera_IsVisible(this)) break;
                this.stateFlag = (short)(this.stateFlag | 8);
            }
        }
    }

    void Platform_ai() {
        int action = this.anim.curAction;
        boolean attached = false;
        if (Game.pRayman.anim.curAction != 27) {
            attached = Game.pRayman.Rayman_checkAttachPlatform(this);
        }
        block0 : switch (action) {
            case 0: {
                if (!attached) break;
                this.anim.newAction = this.V[0];
                break;
            }
            case 5: {
                if (GameMidlet.Instance_Game.Camera_IsVisible(this)) break;
                this.Actor_Reset();
                break;
            }
            case 10: {
                this.V[1] = this.V[1] - 1;
                if (this.V[1] > 0) break;
            }
            default: {
                int nx = (int)(this.x >> 8 >> 4);
                int ny = (int)(this.y >> 8 >> 4);
                this.Actor_SetReferencePoint(nx, ny);
                byte phb = this.Actor_GetPHB(nx, ny);
                switch (phb) {
                    case 28: {
                        this.anim.newAction = 5;
                        break block0;
                    }
                    case 20: {
                        if (action == 4) {
                            this.V[1] = 20;
                            this.anim.newAction = 10;
                            break block0;
                        }
                        this.anim.newAction = 6;
                        break block0;
                    }
                    case 21: {
                        if (action == 6) {
                            this.V[1] = 20;
                            this.anim.newAction = 10;
                            break block0;
                        }
                        this.anim.newAction = 4;
                        break block0;
                    }
                    case 22: {
                        this.anim.newAction = 8;
                        break block0;
                    }
                    case 23: {
                        this.anim.newAction = 2;
                        break block0;
                    }
                    case 24: {
                        this.anim.newAction = 9;
                        break block0;
                    }
                    case 25: {
                        this.anim.newAction = 7;
                        break block0;
                    }
                    case 26: {
                        this.anim.newAction = 3;
                        break block0;
                    }
                    case 27: {
                        this.anim.newAction = 1;
                    }
                }
            }
        }
        int f = 0;
        while (f < 2) {
            if (Game.pFist[f].anim.curAction == 1 && Game.pFist[f].Fist_CheckCollision(this)) {
                Game.pFist[f].anim.newAction = 3;
            }
            ++f;
        }
    }

    void Fist_checkHitBackEnd() {
        Actor pRayman = Game.pRayman;
        if (this.actorReference != null) {
            this.dx = 0;
            this.anim.newAction = 5;
        } else {
            int ndx = (int)(this.x - pRayman.x);
            if (ndx < 0) {
                ndx *= -1;
            }
            if (ndx < 3072 || (this.stateFlag & 1) == 0 && this.x > pRayman.x || (this.stateFlag & 1) != 0 && this.x < pRayman.x || ndx > 122880) {
                this.stateFlag = (short)(this.stateFlag | 8);
                this.anim.curAction = 0;
            } else {
                int ndy = (int)(pRayman.y - this.y);
                ndy = ndy * 1024 / ndx;
                this.dy = (short)(this.dy + ndy);
            }
        }
    }

    void Fist_ai() {
        int action = this.anim.curAction;
        switch (action) {
            case 1: {
                if (this.actorReference != null) {
                    this.dx = 0;
                    this.anim.newAction = 3;
                    break;
                }
                if (this.mmodel_vX >= 0) {
                    this.anim.newAction = 4;
                    break;
                }
                if (this.Actor_GetPHB((int)(this.x >> 8 >> 4), (int)((this.y >> 8) + (long)this.colBox[1] >> 4)) != 1) break;
                this.anim.newAction = 3;
                break;
            }
            case 2: {
                if (!this.Ani_CheckEnd()) break;
                this.anim.newAction = 4;
                break;
            }
            case 4: {
                this.Fist_checkHitBackEnd();
                break;
            }
            case 3: {
                this.Fist_checkHitBackEnd();
                if (!this.Ani_CheckEnd()) break;
                this.anim.newAction = 4;
                break;
            }
            case 5: {
                if (!this.Ani_CheckEnd()) break;
                this.anim.newAction = 4;
            }
        }
        this.actorReference = null;
    }

    void Fist_launch(int ndir, int energy) {
        int offsetX;
        Actor pRayman = Game.pRayman;
        this.stateFlag = (byte)(ndir | this.stateFlag & 0xFFFFFFFA);
        if ((pRayman.stateFlag & 1) == 0) {
            pRayman.xDirectionConfirmed = false;
            pRayman.xDirectionConfirmationCounter = -2;
            offsetX = -1024;
        } else {
            pRayman.xDirectionConfirmed = true;
            pRayman.xDirectionConfirmationCounter = 2;
            offsetX = 1024;
        }
        if (energy > 11520) {
            energy = 11520;
        }
        this.mmodel_vX = (short)(-energy);
        int n_damage = 1;
        int energy_factor = 4800 / n_damage;
        Actor.fist_energy[this.fist_top] = 2 + (energy - 6720) / energy_factor;
        this.dy = 0;
        this.dx = 0;
        this.x = pRayman.x + (long)pRayman.dx + (long)offsetX;
        this.y = pRayman.y - (long)pRayman.dy;
        this.stateFlag = (short)(this.stateFlag & 0xFFFFFFF7);
        this.anim.newAction = 1;
    }

    boolean Fist_CheckCollision(Actor des) {
        if ((this.stateFlag & 8) != 0) {
            return false;
        }
        if (this.GameObj_checkCollsion(des)) {
            this.actorReference = des;
            return true;
        }
        return false;
    }

    int getAvailableFist() {
        if ((Game.pFist[0].stateFlag & 8) != 0) {
            return 0;
        }
        if ((Game.pFist[1].stateFlag & 8) != 0) {
            return 1;
        }
        return -1;
    }

    void LevelSign_ai() {
        int action = this.anim.curAction;
        switch (action) {
            case 0: 
            case 2: {
                if (this.GameObj_checkCollsion(Game.pRayman)) {
                    Game.pRayman.actorReference = this;
                    break;
                }
                if (Game.pRayman.actorReference != this) break;
                Game.pRayman.actorReference = null;
                break;
            }
            case 1: {
                if ((this.V[0] > 8 || this.V[0] > Game.m_gameFrame_unlockedLevel) && ((Game.s_iLumsTaken & 0xFF) < 140 || Game.s_iCageOpened < 12)) break;
                this.anim.newAction = 4;
                break;
            }
            case 4: {
                if (!this.Ani_CheckEnd()) break;
                this.anim.newAction = 2;
                break;
            }
            case 3: {
                int raymanAction = Game.pRayman.anim.curAction;
                if (this.GameObj_checkCollsion(Game.pRayman) && (raymanAction == 0 || raymanAction == 2 || raymanAction == 4 || raymanAction == 3 || raymanAction == 5 || raymanAction == 6 || raymanAction == 15 || raymanAction == 16 || raymanAction == 13 || raymanAction == 39 || raymanAction == 40)) {
                    if (Game.pRayman.actorReference == this) break;
                    Game.pRayman.actorReference = this;
                    Game.m_iGlobalTicker = 21;
                    break;
                }
                if (Game.pRayman.actorReference != this) break;
                Game.pRayman.actorReference = null;
            }
        }
    }

    void LevelPost_ai() {
        int action = this.anim.curAction;
        switch (action) {
            case 0: {
                if (!this.GameObj_checkCollsion(Game.pRayman) || Game.pRayman.anim.curAction != 0 && Game.pRayman.anim.curAction != 2 || !this.Actor_Death()) break;
                break;
            }
        }
    }

    void Bullet_ai() {
        if (!GameMidlet.Instance_Game.Camera_IsVisible(this)) {
            this.stateFlag = (short)(this.stateFlag | 8);
        }
        if (this.GameObj_checkCollsion(Game.pRayman)) {
            Game.pRayman.doDamage();
            this.stateFlag = (short)(this.stateFlag | 8);
        }
    }

    void Pirate_ai() {
        if (this.checkFloor()) {
            this.mmodel_type = 0;
        } else {
            this.mmodel_fY = (short)1792;
            this.mmodel_aY = (short)256;
            this.mmodel_type = (short)10;
        }
        switch (this.anim.curAction) {
            case 0: {
                if ((Game.pRayman.stateFlag & 8) != 0) break;
                if (this.V[3] % 15 == 0) {
                    if ((this.V[2] & 0x10000) != 0) {
                        this.anim.newAction = 1;
                        this.V[3] = this.V[3] - 15;
                    } else if ((this.V[2] & 1) != 0) {
                        this.anim.newAction = 3;
                        this.V[3] = this.V[3] - 15;
                    } else {
                        this.V[3] = this.V[3] - 1;
                    }
                    this.V[2] = this.V[2] >> 1;
                } else {
                    this.V[3] = this.V[3] - 1;
                }
                if (this.V[3] > 0) break;
                this.V[2] = this.m_iInitV[2];
                this.V[3] = this.m_iInitV[3];
                break;
            }
            case 1: {
                if (!this.Ani_CheckEnd()) break;
                Actor bullet = GameMidlet.Instance_Game.actors[this.V[0]];
                if ((this.stateFlag & 1) == 0 && bullet.mmodel_vX > 0 || (this.stateFlag & 1) != 0 && bullet.mmodel_vX < 0) {
                    bullet.mmodel_vX = -bullet.mmodel_vX;
                }
                bullet.x = this.x - (long)(10240 * ((this.stateFlag & 1) == 0 ? 1 : -1)) + (long)this.dx;
                bullet.y = this.y - 11776L + (long)this.dy;
                bullet.stateFlag = (short)(bullet.stateFlag & 0xFFFFFFF7);
                this.V[4] = 0;
                this.anim.newAction = 2;
                break;
            }
            case 2: {
                if (!this.Ani_CheckEnd()) break;
                this.anim.newAction = 0;
                break;
            }
            case 3: {
                if (!this.Ani_CheckEnd()) break;
                Actor bullet = GameMidlet.Instance_Game.actors[this.V[0]];
                if ((this.stateFlag & 1) == 0 && bullet.mmodel_vX > 0 || (this.stateFlag & 1) != 0 && bullet.mmodel_vX < 0) {
                    bullet.mmodel_vX = -bullet.mmodel_vX;
                }
                bullet.x = this.x - (long)(10240 * ((this.stateFlag & 1) == 0 ? 1 : -1)) + (long)this.dx;
                bullet.y = this.y - 5120L + (long)this.dy;
                bullet.stateFlag = (short)(bullet.stateFlag & 0xFFFFFFF7);
                this.V[4] = 0;
                this.anim.newAction = 4;
                break;
            }
            case 4: {
                if (!this.Ani_CheckEnd()) break;
                this.anim.newAction = 0;
                break;
            }
            case 5: {
                if (!this.Ani_CheckEnd()) break;
                while (this.V[3] % 15 != 0) {
                    this.V[3] = this.V[3] - 1;
                }
                int i = 0;
                while (i < 16) {
                    if ((this.V[2] & 0x10000) != 0 || (this.V[2] & 1) != 0) break;
                    this.V[2] = this.V[2] >> 1;
                    this.V[3] = this.V[3] - 15;
                    if (this.V[3] == 0) {
                        this.V[2] = this.m_iInitV[2];
                        this.V[3] = this.m_iInitV[3];
                    }
                    ++i;
                }
                this.anim.newAction = 0;
                break;
            }
            case 6: {
                if (this.Ani_CheckEnd()) {
                    if ((this.stateFlag & 0x20) != 0) {
                        this.stateFlag = (short)(this.stateFlag | 0x40);
                    } else {
                        this.Actor_Death();
                    }
                }
                return;
            }
        }
        boolean pirateHit = false;
        if (this.V[4] == 0) {
            int f = 0;
            while (f < 2) {
                pirateHit = Game.pFist[f].Fist_CheckCollision(this);
                if (!pirateHit) {
                    ++f;
                    continue;
                }
                break;
            }
        } else {
            this.V[4] = this.V[4] - 1;
        }
        if (pirateHit) {
            this.V[1] = this.V[1] - fist_energy[this.fist_top];
            if (this.V[1] > 0) {
                this.anim.newAction = 5;
                this.V[4] = 50;
                GameMidlet.Instance_Game.PlaySound(26, true);
            } else {
                this.anim.newAction = 6;
                GameMidlet.Instance_Game.PlaySound(25, true);
            }
        } else if (this.GameObj_checkCollsion(Game.pRayman)) {
            Game.pRayman.doDamage();
            if ((this.stateFlag & 1) == 0 && (Game.pRayman.stateFlag & 1) != 0 || (this.stateFlag & 1) != 0 && (Game.pRayman.stateFlag & 1) == 0) {
                Game.pRayman.mmodel_vX = 0;
                Game.pRayman.dx = 0;
            }
        }
    }

    boolean checkCeilingStandUp() {
        int nx = (int)(this.x >> 8 >> 4);
        int ny = (int)(this.y >> 8 >> 4);
        byte height = Actor.aniData[0].frames[Actor.aniData[0].actions[0][1]][3];
        int heightInTiles = Math.abs(height / 16);
        if (height % 16 != 0) {
            ++heightInTiles;
        }
        int i = 1;
        while (i <= heightInTiles) {
            byte phb = this.Actor_GetPHB(nx, ny - i);
            if (phb == 1 || phb == 31) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void jumpUp(int vX, int deltaX) {
        if (this.actorReference != null && (this.actorReference.objType == 11 || this.actorReference.objType == 10)) {
            this.actorReference = null;
            this.dy = (short)(this.dy - 512);
        }
        if (vX > 0) {
            this.mmodel_vX = this.checkClimb() ? (short)(-(vX - deltaX)) : (short)(this.mmodel_vX - (vX - deltaX));
            this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
        } else if (vX < 0) {
            this.mmodel_vX = this.checkClimb() ? (short)(vX + deltaX) : (short)(this.mmodel_vX + (vX + deltaX));
            this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
        } else {
            this.mmodel_vX = (short)((this.stateFlag & 5) != 0 ? -deltaX : deltaX);
        }
        this.anim.newAction = 7;
        if (this.mmodel_vX > 1792) {
            this.mmodel_vX = (short)1792;
        } else if (this.mmodel_vX < -1792) {
            this.mmodel_vX = (short)-1792;
        }
        this.V[16] = (int)(this.y >> 8);
        this.V[15] = 0;
        this.mmodel_aX = 0;
    }

    void startFly(int vX) {
        if ((this.V[0] & 2) != 2) {
            return;
        }
        this.anim.newAction = 9;
        this.mmodel_aX = 0;
        if (vX > 0) {
            this.mmodel_vX = (short)(-vX);
            this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
        } else if (vX < 0) {
            this.mmodel_vX = (short)vX;
            this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
        }
        this.V[6] = 0;
        this.V[0] = this.V[0] & 0xFFFFFFFD;
    }

    void handleKeyEvent() {
        int action = this.anim.curAction;
        int bug = -1;
        try {
            int allKeys;
            switch (action) {
                case 17: {
                    boolean canMoveSide;
                    boolean canFall;
                    boolean canJump;
                    if (this.anim.oldAction == 11 || this.anim.oldAction == 9 || this.anim.oldAction == 7 || this.anim.oldAction == 8 || this.anim.oldAction == 10) {
                        this.yDirectionConfirmed = 0;
                        this.yDirectionConfirmationCounter = 0;
                    }
                    if ((this.V[4] & 0x20) != 0 && (this.fist_top = this.getAvailableFist()) != -1 && (Game.pFist[0].stateFlag & 8) != 0) {
                        this.anim.newAction = 25;
                        this.fist_time[this.fist_top] = 0;
                        return;
                    }
                    if ((this.V[3] & 4) != 0) {
                        canJump = this.checkClimbJump(4);
                        if ((this.V[4] & 4) != 0) {
                            if (canJump) {
                                this.y -= 4096L;
                                this.jumpUp(0, 0);
                            }
                        } else if (!canJump) {
                            this.anim.newAction = 18;
                        }
                    }
                    if ((this.V[3] & 0x100) != 0) {
                        canJump = this.checkClimbJump(8);
                        if ((this.V[4] & 0x100) != 0) {
                            if (canJump) {
                                this.anim.newAction = 11;
                                this.V[15] = 0;
                                this.y += 6144L;
                            }
                        } else if (!canJump) {
                            this.anim.newAction = 20;
                        }
                    }
                    if ((this.V[3] & 0x10) != 0) {
                        this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                        canJump = this.checkClimbJump(1);
                        if ((this.V[4] & 0x10) != 0) {
                            if (canJump) {
                                this.xDirectionConfirmationCounter -= 2;
                            }
                        } else if (!canJump) {
                            this.anim.newAction = 22;
                        }
                    }
                    if ((this.V[3] & 0x40) != 0) {
                        this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                        canJump = this.checkClimbJump(2);
                        if ((this.V[4] & 0x40) != 0) {
                            if (canJump) {
                                this.xDirectionConfirmationCounter += 2;
                            }
                        } else if (!canJump) {
                            this.anim.newAction = 22;
                        }
                    }
                    if ((this.V[3] & 8) != 0) {
                        this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                        canJump = this.checkClimbJump(6);
                        if ((this.V[4] & 8) != 0) {
                            if (canJump) {
                                this.y -= 4096L;
                                this.x += 4096L;
                                if (this.x + (long)(this.colBox[2] << 8) > (long)(GameMidlet.Instance_Game.m_sBackgroundWidth << 4 << 8)) {
                                    this.x = (GameMidlet.Instance_Game.m_sBackgroundWidth << 4) - (this.colBox[2] + 2) << 8;
                                    this.jumpUp(0, 0);
                                } else {
                                    this.jumpUp(1792, 0);
                                }
                            }
                        } else if (!canJump) {
                            this.anim.newAction = 19;
                        }
                    }
                    if ((this.V[3] & 2) != 0) {
                        this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                        canJump = this.checkClimbJump(5);
                        if ((this.V[4] & 2) != 0) {
                            if (canJump) {
                                this.x -= 4096L;
                                this.y -= 4096L;
                                if (this.x + (long)(this.colBox[0] << 8) < 0L) {
                                    this.x = -this.colBox[0] << 8;
                                    this.jumpUp(0, 0);
                                } else {
                                    this.jumpUp(-1792, 0);
                                }
                            }
                        } else if (!canJump) {
                            this.anim.newAction = 19;
                        }
                    }
                    if ((this.V[3] & 0x200) != 0) {
                        this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                        canFall = this.checkClimbJump(8);
                        canMoveSide = this.checkClimbJump(2);
                        if ((this.V[4] & 0x200) != 0) {
                            if (canFall) {
                                this.anim.newAction = 11;
                                this.V[15] = 0;
                                this.y += 6144L;
                            }
                        } else if (!(canFall | canMoveSide)) {
                            this.anim.newAction = 21;
                        }
                    }
                    if ((this.V[3] & 0x80) == 0) break;
                    this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                    canFall = this.checkClimbJump(8);
                    canMoveSide = this.checkClimbJump(1);
                    if ((this.V[4] & 0x80) != 0) {
                        if (!canFall) break;
                        this.anim.newAction = 11;
                        this.V[15] = 0;
                        this.y += 6144L;
                        break;
                    }
                    if (canFall | canMoveSide) break;
                    this.anim.newAction = 21;
                    break;
                }
                case 18: {
                    int allUpKeys = 14;
                    if ((this.V[3] & allUpKeys) != 0 && this.checkClimbJump(4)) {
                        if ((this.V[4] & 4) != 0) {
                            this.jumpUp(0, 0);
                        } else if ((this.V[4] & 2) != 0) {
                            this.jumpUp(-1792, 0);
                        } else if ((this.V[4] & 8) != 0) {
                            this.jumpUp(1792, 0);
                        } else {
                            this.anim.newAction = 17;
                        }
                    }
                    if ((this.V[3] & 4) != 0) break;
                    this.anim.newAction = 17;
                    break;
                }
                case 20: {
                    int allDownKeys = 896;
                    if ((this.V[3] & allDownKeys) != 0 && this.checkClimbJump(8)) {
                        if ((this.V[4] & allDownKeys) != 0) {
                            this.anim.newAction = 11;
                            this.V[15] = 0;
                            this.y += 4096L;
                        } else {
                            this.anim.newAction = 17;
                        }
                    }
                    if ((this.V[3] & 0x100) != 0) break;
                    this.anim.newAction = 17;
                    break;
                }
                case 19: {
                    int keys;
                    boolean canJumpUp;
                    if ((this.V[3] & 2) != 0) {
                        this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                        canJumpUp = this.checkClimbJump(4);
                        boolean canJumpLeft = this.checkClimbJump(1);
                        if (canJumpUp && !canJumpLeft) {
                            this.mmodel_vY = 0;
                        } else if (!canJumpUp && canJumpLeft) {
                            this.mmodel_vX = 0;
                        } else if (canJumpUp && canJumpLeft) {
                            this.anim.newAction = 17;
                        }
                    }
                    if ((this.V[3] & 8) != 0) {
                        this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                        canJumpUp = this.checkClimbJump(4);
                        boolean canJumpRight = this.checkClimbJump(2);
                        if (canJumpUp && !canJumpRight) {
                            this.mmodel_vY = 0;
                        } else if (!canJumpUp && canJumpRight) {
                            this.mmodel_vX = 0;
                        } else if (canJumpUp && canJumpRight) {
                            this.anim.newAction = 17;
                        }
                    }
                    if ((this.V[3] & (keys = (this.stateFlag & 1) == 0 ? 2 : 8)) != 0) break;
                    this.anim.newAction = 17;
                    break;
                }
                case 21: {
                    boolean canJumpDown;
                    int keys;
                    if ((this.V[3] & 0x80) != 0) {
                        this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                        canJumpDown = this.checkClimbJump(8);
                        boolean canJumpLeft = this.checkClimbJump(1);
                        if (canJumpDown && !canJumpLeft) {
                            this.mmodel_vY = 0;
                        } else if (!canJumpDown && canJumpLeft) {
                            this.mmodel_vX = 0;
                        } else if (canJumpDown && canJumpLeft) {
                            this.anim.newAction = 17;
                        }
                    }
                    if ((this.V[3] & 0x200) != 0) {
                        this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                        canJumpDown = this.checkClimbJump(8);
                        boolean canJumpRight = this.checkClimbJump(2);
                        if (canJumpDown && !canJumpRight) {
                            this.mmodel_vY = 0;
                        } else if (!canJumpDown && canJumpRight) {
                            this.mmodel_vX = 0;
                        } else if (canJumpDown && canJumpRight) {
                            this.anim.newAction = 17;
                        }
                    }
                    if ((this.V[3] & (keys = (this.stateFlag & 1) == 0 ? 128 : 512)) != 0) break;
                    this.anim.newAction = 17;
                    break;
                }
                case 22: {
                    boolean canJump;
                    if ((this.V[3] & 0x10) != 0) {
                        canJump = this.checkClimbJump(1);
                        this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                        if (canJump) {
                            this.anim.newAction = 17;
                        }
                    }
                    if ((this.V[3] & 0x40) != 0) {
                        canJump = this.checkClimbJump(2);
                        this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                        if (canJump) {
                            this.anim.newAction = 17;
                        }
                    }
                    if ((this.V[3] & (allKeys = (this.stateFlag & 1) == 0 ? 16 : 64)) != 0) break;
                    this.anim.newAction = 17;
                    break;
                }
                case 27: {
                    if ((this.V[4] & 4) != 0) {
                        this.jumpUp(0, 0);
                    } else if ((this.V[4] & 8) != 0) {
                        this.jumpUp(1792, 0);
                    } else if ((this.V[4] & 2) != 0) {
                        this.jumpUp(-1792, 0);
                    } else {
                        return;
                    }
                    this.x = this.V[13] + (this.colBox[0] + this.colBox[2] >> 1);
                    this.y = this.V[14] + (this.colBox[1] + this.colBox[3] >> 1);
                    this.x <<= 8;
                    this.y <<= 8;
                    this.step();
                    this.actorReference = null;
                    break;
                }
                case 0: 
                case 12: 
                case 39: 
                case 40: {
                    int allUpKeys;
                    if (this.V[3] == 0 && this.V[4] == 0) {
                        this.yDirectionConfirmed = 0;
                        this.yDirectionConfirmationCounter = 0;
                    }
                    if ((this.V[3] & (allUpKeys = 14)) != 0 && (this.V[4] & allUpKeys) != 0) {
                        if ((this.V[4] & 4) != 0) {
                            this.jumpUp(0, 0);
                        } else if ((this.V[4] & 2) != 0) {
                            this.jumpUp(-1792, 0);
                        } else if ((this.V[4] & 8) != 0) {
                            this.jumpUp(1792, 0);
                        }
                    }
                    if ((this.V[3] & 0x100) != 0) {
                        this.anim.newAction = 3;
                    }
                    if ((this.V[3] & 0x10) != 0) {
                        if ((this.stateFlag & 1) == 0 && this.xDirectionConfirmationCounter < -1) {
                            this.anim.newAction = 2;
                        } else {
                            this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                            if (this.actorReference != null && (this.actorReference.objType == 11 || this.actorReference.objType == 10) && this.actorReference.dy != 0 && this.actorReference.dx == 0) {
                                this.xDirectionConfirmed = false;
                                this.xDirectionConfirmationCounter = -2;
                            } else {
                                --this.xDirectionConfirmationCounter;
                            }
                        }
                    }
                    if ((this.V[3] & 0x40) != 0) {
                        if ((this.stateFlag & 1) != 0 && this.xDirectionConfirmationCounter > 1) {
                            this.anim.newAction = 2;
                        } else {
                            this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                            if (this.actorReference != null && (this.actorReference.objType == 11 || this.actorReference.objType == 10) && this.actorReference.dy != 0 && this.actorReference.dx == 0) {
                                this.xDirectionConfirmed = true;
                                this.xDirectionConfirmationCounter = 2;
                            } else {
                                ++this.xDirectionConfirmationCounter;
                            }
                        }
                    }
                    if ((this.V[3] & 0x80) != 0) {
                        this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                        this.anim.newAction = 3;
                    }
                    if ((this.V[3] & 0x200) != 0) {
                        this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                        this.anim.newAction = 3;
                    }
                    if ((this.V[4] & 0x20) != 0) {
                        if (this.actorReference != null && this.actorReference.objType == 6 && (this.actorReference.anim.curAction == 2 || this.actorReference.anim.curAction == 0)) {
                            if (this.actorReference.anim.curAction == 2 || this.actorReference.anim.curAction == 0) {
                                GameMidlet.Instance_Game.PlaySound(29, true);
                            }
                            this.anim.newAction = 37;
                        } else {
                            this.fist_top = this.getAvailableFist();
                            if (this.fist_top != -1) {
                                this.anim.newAction = 15;
                                this.fist_time[this.fist_top] = 0;
                            }
                        }
                    }
                    if (this.V[4] == 0) {
                        this.V[10] = this.V[10] + 1;
                        break;
                    }
                    this.V[10] = 0;
                    break;
                }
                case 2: {
                    if ((this.V[3] & 0x10) != 0) {
                        this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                    } else if ((this.V[3] & 0x40) != 0) {
                        this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                    }
                    if ((this.V[4] & 4) != 0) {
                        this.jumpUp(0, 0);
                    } else if ((this.V[4] & 0x100) != 0) {
                        this.anim.newAction = 3;
                    } else if ((this.V[4] & 8) != 0) {
                        this.jumpUp(1792, -this.mmodel_vX);
                    } else if ((this.V[4] & 2) != 0) {
                        this.jumpUp(-1792, -this.mmodel_vX);
                    } else if ((this.V[4] & 0x80) != 0) {
                        this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                        this.anim.newAction = 3;
                    } else if ((this.V[4] & 0x200) != 0) {
                        this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                        this.anim.newAction = 3;
                    } else if ((this.V[3] & 0x40) == 0 && (this.V[3] & 0x10) == 0) {
                        this.anim.newAction = 0;
                    }
                    if ((this.V[4] & 0x20) == 0 || (this.fist_top = this.getAvailableFist()) == -1) break;
                    this.anim.newAction = 15;
                    this.fist_time[this.fist_top] = 0;
                    break;
                }
                case 9: {
                    if (this.V[7] != 0) {
                        if ((this.V[3] & 4) != 0 || (this.V[3] & 2) != 0 || (this.V[3] & 8) != 0) {
                            this.mmodel_vY = (short)-512;
                        } else {
                            if (this.mmodel_vY < 0) {
                                this.mmodel_vY = 0;
                            }
                            this.mmodel_vY = (short)(this.mmodel_vY + 256);
                            if (this.mmodel_vY > 512) {
                                this.mmodel_vY = (short)512;
                            }
                        }
                    }
                    if ((this.V[3] & 0x10) != 0 || (this.V[3] & 2) != 0 || (this.V[3] & 0x80) != 0) {
                        this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                        if (this.mmodel_vX > -896) {
                            this.mmodel_vX = (short)(this.mmodel_vX - 256);
                            if (this.mmodel_vX < -896) {
                                this.mmodel_vX = (short)-896;
                            }
                        }
                    } else if ((this.V[3] & 0x40) != 0 || (this.V[3] & 8) != 0 || (this.V[3] & 0x200) != 0) {
                        this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                        if (this.mmodel_vX > -896) {
                            this.mmodel_vX = (short)(this.mmodel_vX - 256);
                            if (this.mmodel_vX < -896) {
                                this.mmodel_vX = (short)-896;
                            }
                        }
                    }
                    if ((this.V[3] & 0x10) == 0 && (this.V[3] & 2) == 0 && (this.V[3] & 0x80) == 0 && (this.V[3] & 0x40) == 0 && (this.V[3] & 8) == 0 && (this.V[3] & 0x200) == 0) {
                        this.mmodel_vX = 0;
                    }
                    if ((this.V[3] & 4) == 0 && (this.V[3] & 2) == 0 && (this.V[3] & 8) == 0) {
                        if (this.V[7] != 0) {
                            int n = this.V[8];
                            this.V[8] = n + 1;
                            if (n < 5) {
                                this.mmodel_vY = 0;
                                this.dy = 0;
                            }
                        }
                    } else {
                        this.V[8] = 0;
                    }
                    if ((this.V[4] & 0x20) == 0 || (this.fist_top = this.getAvailableFist()) == -1) break;
                    if (this.V[7] != 0) {
                        this.anim.newAction = 34;
                        break;
                    }
                    this.anim.newAction = 10;
                    Game.pFist[this.fist_top].Fist_launch(this.stateFlag & 1, 8640);
                    break;
                }
                case 34: 
                case 35: {
                    if ((this.V[5] & 0x20) == 0) break;
                    this.anim.newAction = 36;
                    this.fist_top = this.getAvailableFist();
                    if (this.fist_top == -1) break;
                    Game.pFist[this.fist_top].Fist_launch(this.stateFlag & 1, 8640);
                    break;
                }
                case 30: {
                    if ((this.V[3] & 0x10) != 0 || (this.V[3] & 2) != 0) {
                        this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                        this.anim.newAction = 31;
                    } else if ((this.V[3] & 0x40) != 0 || (this.V[3] & 8) != 0) {
                        this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                        this.anim.newAction = 31;
                    }
                    if ((this.V[3] & 0x100) == 0 && (this.V[3] & 0x80) == 0 && (this.V[3] & 0x200) == 0) break;
                    this.yDirectionConfirmed = 1;
                    this.yDirectionConfirmationCounter = 5;
                    this.anim.newAction = 11;
                    this.y += 4096L;
                    break;
                }
                case 31: {
                    if ((this.V[3] & 0x10) != 0 || (this.V[3] & 2) != 0) {
                        this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                    } else if ((this.V[3] & 0x40) != 0 || (this.V[3] & 8) != 0) {
                        this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                    }
                    if ((this.V[5] & 0x100) != 0 || (this.V[5] & 0x80) != 0 || (this.V[5] & 0x200) != 0) {
                        this.yDirectionConfirmed = 1;
                        this.yDirectionConfirmationCounter = 5;
                        this.anim.newAction = 11;
                        this.y += 4096L;
                        break;
                    }
                    if ((this.V[3] & 0x10) != 0 || (this.V[3] & 2) != 0 || (this.V[3] & 0x40) != 0 || (this.V[3] & 8) != 0) break;
                    this.anim.newAction = 30;
                    break;
                }
                case 11: {
                    if ((this.V[4] & 4) != 0 || (this.V[4] & 8) != 0 || (this.V[4] & 2) != 0) {
                        this.startFly(0);
                    } else if ((this.V[4] & 8) != 0) {
                        this.startFly(1792);
                    } else if ((this.V[4] & 2) != 0) {
                        this.startFly(-1792);
                    }
                    if ((this.V[3] & 0x10) != 0 || (this.V[3] & 2) != 0 || (this.V[3] & 0x80) != 0) {
                        this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                        if (this.mmodel_vX > -1792) {
                            this.mmodel_vX = (short)(this.mmodel_vX - 256);
                            if (this.mmodel_vX < -1792) {
                                this.mmodel_vX = (short)-1792;
                            }
                        }
                    } else if ((this.V[3] & 0x40) != 0 || (this.V[3] & 8) != 0 || (this.V[3] & 0x200) != 0) {
                        this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                        if (this.mmodel_vX > -1792) {
                            this.mmodel_vX = (short)(this.mmodel_vX - 256);
                            if (this.mmodel_vX < -1792) {
                                this.mmodel_vX = (short)-1792;
                            }
                        }
                    }
                    if ((this.V[3] & 0x10) != 0 || (this.V[3] & 2) != 0 || (this.V[3] & 0x80) != 0 || (this.V[3] & 0x40) != 0 || (this.V[3] & 8) != 0 || (this.V[3] & 0x200) == 0) {
                        // empty if block
                    }
                    if ((this.V[4] & 0x20) == 0 || (this.fist_top = this.getAvailableFist()) == -1) break;
                    this.anim.newAction = 10;
                    Game.pFist[this.fist_top].Fist_launch(this.stateFlag & 1, 8640);
                    break;
                }
                case 7: {
                    if (this.anim.oldAction == 28 || this.anim.oldAction == 29) {
                        this.mmodel_vY = (short)(this.mmodel_vY - 256);
                        this.V[9] = 0x7FFFFFF;
                        break;
                    }
                    this.V[9] = 0;
                    break;
                }
                case 8: {
                    if ((this.V[4] & 4) != 0) {
                        if (this.mmodel_vX < 0) {
                            this.mmodel_vX = 0;
                        }
                        this.mmodel_vY = 0;
                        this.mmodel_aY = 0;
                        this.startFly(0);
                    } else if ((this.V[4] & 8) != 0) {
                        this.mmodel_vY = 0;
                        this.mmodel_aY = 0;
                        this.startFly(1792);
                    } else if ((this.V[4] & 2) != 0) {
                        this.mmodel_vY = 0;
                        this.mmodel_aY = 0;
                        this.startFly(-1792);
                    }
                    if ((this.V[3] & 4) != 0 || (this.V[3] & 2) != 0 || (this.V[3] & 8) != 0) {
                        int n = this.V[9];
                        this.V[9] = n + 1;
                        if (n < 8) {
                            this.mmodel_vY = (short)(this.mmodel_vY - 153);
                        }
                    }
                    if ((this.V[3] & 0x10) != 0 || (this.V[3] & 2) != 0 || (this.V[3] & 0x80) != 0) {
                        this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                        if (this.mmodel_vX > -1792) {
                            this.mmodel_vX = (short)(this.mmodel_vX - 256);
                            if (this.mmodel_vX < -1792) {
                                this.mmodel_vX = (short)-1792;
                            }
                        }
                    } else if ((this.V[3] & 0x40) != 0 || (this.V[3] & 8) != 0 || (this.V[3] & 0x200) != 0) {
                        this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                        if (this.mmodel_vX > -1792) {
                            this.mmodel_vX = (short)(this.mmodel_vX - 256);
                            if (this.mmodel_vX < -1792) {
                                this.mmodel_vX = (short)-1792;
                            }
                        }
                    }
                    if ((this.V[3] & 0x10) != 0 || (this.V[3] & 2) != 0 || (this.V[3] & 0x80) != 0 || (this.V[3] & 0x40) != 0 || (this.V[3] & 8) != 0 || (this.V[3] & 0x200) == 0) {
                        // empty if block
                    }
                    if ((this.V[4] & 0x20) == 0 || (this.fist_top = this.getAvailableFist()) == -1) break;
                    this.anim.newAction = 10;
                    Game.pFist[this.fist_top].Fist_launch(this.stateFlag & 1, 8640);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    if ((this.V[3] & 0x10) != 0 || (this.V[3] & 0x80) != 0) {
                        this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                        this.anim.newAction = 5;
                    } else if ((this.V[3] & 0x40) != 0 || (this.V[3] & 0x200) != 0) {
                        this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                        this.anim.newAction = 5;
                    }
                    if ((this.V[3] & 0x100) != 0 || (this.V[3] & 0x80) != 0 || (this.V[3] & 0x200) != 0 || this.checkCeilingStandUp()) break;
                    this.anim.newAction = 6;
                    break;
                }
                case 5: {
                    if ((this.V[3] & 0x80) != 0) {
                        this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                    } else if ((this.V[3] & 0x200) != 0) {
                        this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                    } else if ((this.V[3] & 0x100) != 0) {
                        this.anim.newAction = 4;
                    }
                    if ((this.V[3] & 0x100) != 0 || (this.V[3] & 0x80) != 0 || (this.V[3] & 0x200) != 0) break;
                    if (!this.checkCeilingStandUp()) {
                        this.anim.newAction = 6;
                        break;
                    }
                    this.anim.newAction = 4;
                    break;
                }
                case 6: {
                    if ((this.V[4] & 0x20) == 0 || this.checkCeilingStandUp()) break;
                    this.anim.newAction = 15;
                    if (this.fist_top == -1) break;
                    this.fist_time[this.fist_top] = 0;
                    break;
                }
                case 10: {
                    break;
                }
                case 36: {
                    break;
                }
                case 13: {
                    if ((this.V[4] & 4) != 0) {
                        this.jumpUp(0, 0);
                        break;
                    }
                    if ((this.V[3] & 0x100) != 0) {
                        this.anim.newAction = 3;
                        break;
                    }
                    if ((this.V[4] & 0x10) != 0) {
                        this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                        this.anim.newAction = 2;
                        break;
                    }
                    if ((this.V[4] & 0x40) != 0) {
                        this.anim.newAction = 2;
                        this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                        break;
                    }
                    if ((this.V[4] & 8) != 0) {
                        this.jumpUp(1792, 0);
                        break;
                    }
                    if ((this.V[4] & 2) != 0) {
                        this.jumpUp(-1792, 0);
                        break;
                    }
                    if ((this.V[4] & 0x80) != 0) {
                        this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                        this.anim.newAction = 3;
                        break;
                    }
                    if ((this.V[4] & 0x80) == 0) break;
                    this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                    this.anim.newAction = 3;
                    break;
                }
                case 15: {
                    if ((this.V[5] & 0x20) == 0) break;
                    this.anim.newAction = 13;
                    this.fist_top = this.getAvailableFist();
                    if (this.fist_top == -1) break;
                    Game.pFist[this.fist_top].Fist_launch(this.stateFlag & 1, this.fist_time[this.fist_top] * 240 + 6720);
                    break;
                }
                case 16: {
                    if ((this.V[5] & 0x20) != 0) {
                        this.anim.newAction = 13;
                        this.fist_top = this.getAvailableFist();
                        if (this.fist_top != -1) {
                            Game.pFist[this.fist_top].Fist_launch(this.stateFlag & 1, this.fist_time[this.fist_top] * 240 + 6720);
                        }
                    }
                    bug = 8;
                    break;
                }
                case 23: {
                    break;
                }
                case 24: {
                    break;
                }
                case 25: {
                    if ((this.V[5] & 0x20) == 0) break;
                    this.anim.newAction = 23;
                    this.fist_top = this.getAvailableFist();
                    if (this.fist_top == -1) break;
                    Game.pFist[this.fist_top].Fist_launch(this.stateFlag & 1, this.fist_time[this.fist_top] * 240 + 6720);
                    break;
                }
                case 28: {
                    this.yDirectionConfirmed = 0;
                    this.yDirectionConfirmationCounter = 0;
                    if ((this.V[4] & 4) != 0) {
                        if ((this.stateFlag & 1) == 0) {
                            this.jumpUp(-256, 0);
                            break;
                        }
                        this.jumpUp(256, 0);
                        break;
                    }
                    if ((this.V[4] & 0x100) != 0) {
                        this.y += 4096L;
                        this.x = (this.stateFlag & 1) == 0 ? (this.x += 512L) : (this.x -= 512L);
                        this.anim.newAction = 11;
                        break;
                    }
                    if ((this.V[4] & 8) != 0) {
                        this.jumpUp(256, 0);
                        break;
                    }
                    if ((this.V[4] & 2) == 0) break;
                    this.jumpUp(-256, 0);
                    break;
                }
                case 29: {
                    if ((this.V[4] & 4) != 0) {
                        if ((this.stateFlag & 1) == 0) {
                            this.jumpUp(-256, 0);
                            break;
                        }
                        this.jumpUp(256, 0);
                        break;
                    }
                    if ((this.V[4] & 0x100) != 0) {
                        this.y += 4096L;
                        this.x = (this.stateFlag & 1) == 0 ? (this.x += 512L) : (this.x -= 512L);
                        this.anim.newAction = 11;
                        break;
                    }
                    if ((this.V[4] & 8) != 0) {
                        this.jumpUp(256, 0);
                        break;
                    }
                    if ((this.V[4] & 2) == 0) break;
                    this.jumpUp(-256, 0);
                }
            }
            allKeys = 146;
            if ((this.V[4] & allKeys) != 0) {
                --this.xDirectionConfirmationCounter;
            }
            if ((this.V[4] & (allKeys = 584)) != 0) {
                ++this.xDirectionConfirmationCounter;
            }
        }
        catch (Exception e) {
            System.out.println(" action " + action + "  exception " + e + " bug " + bug);
            System.out.println("Game.pFist " + Game.pFist + " fist_time " + this.fist_time);
            System.out.println("fist_top " + this.fist_top + " fist_top " + this.fist_top);
            System.out.println("Game.pFist[fist_top] " + Game.pFist[this.fist_top]);
            System.out.println(" fist_time[fist_top] " + this.fist_time[this.fist_top]);
        }
    }

    boolean checkCeilingAir() {
        int nx = (int)(this.x >> 8 >> 4);
        int ny = (int)((this.y + (long)this.dy >> 8) + (long)this.colBox[1] >> 4);
        byte phb = this.Actor_GetPHB(nx, ny);
        if (phb == 1) {
            while (phb == 1) {
                phb = this.Actor_GetPHB(nx, ++ny);
            }
            this.y = (ny << 4) - this.colBox[1] + 2 << 8;
            this.dy = 0;
            return true;
        }
        return false;
    }

    boolean canHangRoof() {
        int nx = (int)(this.x + (long)this.dx >> 8 >> 4);
        int ny = (int)((this.y + (long)this.dy >> 8) - 58L >> 4);
        byte phb = this.Actor_GetPHB(nx, ny);
        if (phb == 30) {
            this.y = (ny << 4) + 58 + 8 << 8;
            this.dy = 0;
            return true;
        }
        return false;
    }

    boolean checkClimb() {
        int tileX = (int)(this.x + (long)this.dx >> 8 >> 4);
        int topTileY = (int)((this.y + (long)this.dy >> 8) + (long)this.colBox[1] >> 4);
        int bottomTileY = (int)((this.y + (long)this.dy >> 8) + (long)this.colBox[3] >> 4);
        if (this.Actor_GetPHB(tileX, topTileY) == 16 && this.Actor_GetPHB(tileX, topTileY + 1) == 16) {
            if (this.Actor_GetPHB(tileX + 1, topTileY) != 16) {
                this.x = (tileX << 4) + 16 - this.colBox[2] << 8;
            } else if (this.Actor_GetPHB(tileX - 1, topTileY) != 16) {
                this.x = (tileX << 4) - this.colBox[0] << 8;
            }
            if (this.dy > 0 && this.Actor_GetPHB(tileX, topTileY - 1) != 16) {
                this.y = (topTileY << 4) - this.colBox[1] << 8;
            } else if (this.dy < 0 && this.Actor_GetPHB(tileX, topTileY + 2) != 16) {
                this.y = (topTileY << 4) - this.colBox[1] << 8;
            }
            this.dy = 0;
            this.dx = 0;
            this.V[15] = 1;
        } else {
            this.V[15] = 0;
        }
        return this.V[15] == 1;
    }

    boolean checkClimbJump(int sides) {
        int tileX = -100;
        int tileY = -100;
        if ((sides & 1) != 0) {
            tileX = (int)((this.x + (long)this.dx >> 8) + (long)this.colBox[2] >> 4);
        }
        if ((sides & 2) != 0) {
            tileX = (int)((this.x + (long)this.dx >> 8) + (long)this.colBox[0] - 1L >> 4);
        }
        if ((sides & 4) != 0) {
            tileY = (int)((this.y + (long)this.dy >> 8) + (long)this.colBox[1] + 8L >> 4);
        }
        if ((sides & 8) != 0) {
            tileY = (int)((this.y + (long)this.dy >> 8) + (long)this.colBox[1] >> 4);
        }
        if (tileX == -100) {
            tileX = (int)(this.x + (long)this.dx >> 8 >> 4);
        }
        if (tileY == -100) {
            tileY = (int)((this.y + (long)this.dy >> 8) + (long)this.colBox[1] >> 4);
        }
        if ((sides & 1) != 0) {
            --tileX;
        }
        if ((sides & 2) != 0) {
            ++tileX;
        }
        if ((sides & 4) != 0) {
            --tileY;
        }
        if ((sides & 8) != 0) {
            tileY += 2;
        }
        return this.Actor_GetPHB(tileX, tileY) == 0;
    }

    boolean canHangOnLedge() {
        boolean bFaceLeft = (this.stateFlag & 1) == 0;
        int posX = (int)(this.x + (long)this.dx) >> 8;
        int posY = (int)(this.y + (long)this.dy) >> 8;
        posX = bFaceLeft ? (posX += this.colBox[0] - 8) : (posX += this.colBox[2] + 8);
        int tileX = posX >> 4;
        int tileY = (int)((this.y + (long)this.dy >> 8) + (long)this.colBox[1] + 16L) >> 4;
        byte phb = this.Actor_GetPHB(tileX, tileY);
        int behindtileX = tileX;
        behindtileX = bFaceLeft ? ++behindtileX : --behindtileX;
        byte behindPhb = this.Actor_GetPHB(behindtileX, tileY);
        if (phb == 31 || behindPhb == 31) {
            this.anim.newAction = 28;
            this.x = behindPhb == 31 ? (long)(behindtileX << 4) : (long)(tileX << 4);
            this.y = (tileY << 4) - this.colBox[1] - 8;
            this.x = bFaceLeft ? (this.x -= (long)(this.colBox[0] - 16 + 4)) : (this.x -= (long)(this.colBox[2] - 4));
            this.dy = 0;
            this.dx = 0;
            this.x <<= 8;
            this.y <<= 8;
            return true;
        }
        return false;
    }

    void doDamage() {
        if (this.V[12] > 0 || (this.stateFlag & 8) != 0) {
            return;
        }
        if ((Game.m_gameFrame_nEnergy = (byte)(Game.m_gameFrame_nEnergy - (Game.m_gameFrame_nEnergy > 0 ? (byte)1 : 0))) == 0) {
            this.anim.newAction = 33;
            GameMidlet.Instance_Game.PlaySound(40, true);
        } else {
            this.V[1] = 1;
            this.V[12] = 1;
            GameMidlet.Instance_Game.PlaySound(42, true);
        }
        Game.Status_Show(0);
    }

    boolean checkDamage() {
        int i = (int)(this.y + (long)(this.colBox[1] << 8));
        while ((long)i <= this.y + (long)(this.colBox[3] << 8)) {
            byte phb = this.Actor_GetPHB((int)(this.x >> 8 >> 4), i >> 8 >> 4);
            if (phb == 18) {
                this.anim.newAction = 33;
                GameMidlet.Instance_Game.PlaySound(40, true);
                return true;
            }
            if (phb == 29 || this.bWasPHBStop) {
                this.anim.newAction = 32;
                this.bWasPHBStop = false;
                GameMidlet.Instance_Game.PlaySound(44, true);
                return true;
            }
            if (phb == 17) {
                this.doDamage();
                return true;
            }
            i += 4096;
        }
        if (Game.m_gameFrame_nEnergy <= 0) {
            this.anim.newAction = 33;
            GameMidlet.Instance_Game.PlaySound(40, true);
            return true;
        }
        return false;
    }

    boolean Rayman_checkAttachPlatform(Actor rpAttach) {
        if (this.actorReference != null || this.dy < 0) {
            return false;
        }
        int nx = (int)(this.x >> 8);
        int ny = (int)(this.y >> 8) + 5;
        int l = (int)((long)rpAttach.colBox[0] + (rpAttach.x >> 8));
        int t = (int)((long)rpAttach.colBox[1] + (rpAttach.y >> 8));
        int r = (int)((long)rpAttach.colBox[2] + (rpAttach.x >> 8));
        int b = (int)((long)rpAttach.colBox[3] + (rpAttach.y >> 8));
        if (nx >= l && nx < r && ny >= t && ny < b) {
            this.actorReference = rpAttach;
            this.dy = 0;
            this.dx = 0;
            this.mmodel_vY = 0;
            this.mmodel_vX = 0;
            this.mmodel_aY = 0;
            this.mmodel_aX = 0;
            this.y = rpAttach.y + (long)(rpAttach.colBox[1] << 8) + (long)rpAttach.dy;
            this.anim.newAction = 12;
            return true;
        }
        return false;
    }

    void Rayman_doPlatform() {
        int nx = (int)(this.x >> 8);
        int l = (int)((long)this.actorReference.colBox[0] + (this.actorReference.x >> 8));
        int r = (int)((long)this.actorReference.colBox[2] + (this.actorReference.x >> 8));
        if (nx < l || nx >= r) {
            this.anim.newAction = 11;
            if (this.actorReference.dy == 0 && this.actorReference.dx != 0) {
                this.y += (long)(this.actorReference.colBox[3] - this.actorReference.colBox[1] + 2 << 8);
                this.x = (this.stateFlag & 1) == 0 ? (this.x -= 2048L) : (this.x += 2048L);
            }
            this.actorReference = null;
        } else {
            this.y = this.actorReference.y + (long)(this.actorReference.colBox[1] << 8);
            this.dy = this.actorReference.dy;
            this.dx = (short)(this.dx + this.actorReference.dx);
        }
    }

    void Rayman_ai() {
        int action = this.anim.curAction;
        this.Actor_SetReferencePoint((int)(this.x >> 8 >> 4), (int)(this.y >> 8 >> 4));
        this.V[4] = GameMidlet.Instance_Game.pressedKey;
        this.V[5] = GameMidlet.Instance_Game.releasedKey;
        this.V[3] = GameMidlet.Instance_Game.currentKey;
        if (Game.m_gameFrame_curLevel > 0 && Game.s_iLeftToDie == 0 && (action == 0 || action == 2 || action == 5 || action == 4 || Game.pRayman.anim.curAction == 12)) {
            this.V[3] = 0;
            this.V[4] = 0;
            this.V[5] = 0;
            this.anim.newAction = 38;
        }
        if (this.V[12] > 0) {
            this.V[12] = this.V[12] + 1;
            if (this.V[12] == 25) {
                this.V[12] = 0;
            }
            if (this.V[1] > 0) {
                this.V[1] = this.V[1] + 1;
                if (this.V[1] == 15) {
                    this.V[1] = 0;
                }
            }
        }
        if ((action == 15 || action == 16 || action == 25 || action == 35) && this.fist_top != -1) {
            int n = this.fist_top;
            this.fist_time[n] = this.fist_time[n] + 1;
        }
        if (this.Ani_CheckEnd()) {
            switch (action) {
                case 39: 
                case 40: {
                    this.anim.newAction = 0;
                    this.V[10] = 0;
                    break;
                }
                case 27: {
                    this.stateFlag = (this.stateFlag & 1) == 0 ? (short)((byte)(1 | this.stateFlag & 0xFFFFFFFA)) : (short)((byte)(0 | this.stateFlag & 0xFFFFFFFA));
                    this.step();
                    this.anim.newAction = 27;
                    break;
                }
                case 34: {
                    this.anim.newAction = 35;
                    break;
                }
                case 23: {
                    this.anim.newAction = 17;
                    break;
                }
                case 36: {
                    if (this.V[7] != 0) {
                        this.anim.newAction = 9;
                        break;
                    }
                    this.anim.newAction = 8;
                    break;
                }
                case 10: {
                    this.anim.newAction = 8;
                    break;
                }
                case 7: {
                    this.anim.newAction = 8;
                    break;
                }
                case 6: 
                case 12: {
                    this.anim.newAction = 0;
                    break;
                }
                case 3: {
                    this.anim.newAction = 4;
                    break;
                }
                case 28: {
                    this.anim.newAction = 29;
                    break;
                }
                case 38: {
                    if (Game.m_gameFrame_unlockedLevel <= Game.m_gameFrame_curLevel) {
                        Game.m_gameFrame_unlockedLevel = (byte)(Game.m_gameFrame_curLevel + 1);
                    }
                    this.anim.newAction = 0;
                    Game.m_gameStateStep = 0;
                    Game.GameFrame_PostMessage(2, 0);
                    break;
                }
                case 37: {
                    this.m_lInitX = this.actorReference.x;
                    this.m_lInitY = this.actorReference.y;
                    this.anim.newAction = 0;
                    this.stateFlag = (short)(this.stateFlag | 8);
                    Game.m_gameStateStep = 0;
                    Game.GameFrame_PostMessage(2, this.actorReference.V[0]);
                    break;
                }
                case 32: 
                case 33: {
                    this.stateFlag = (short)(this.stateFlag | 8);
                    Game.GameFrame_PostMessage(1, 0);
                    if (Game.s_iLeftToDie == 0) {
                        Game.s_iLeftToDie = 1;
                    }
                    return;
                }
                case 15: {
                    this.anim.newAction = 16;
                    break;
                }
                case 13: {
                    this.anim.newAction = 0;
                }
            }
        }
        if ((action == 8 || action == 7) && this.mmodel_vY > 0) {
            this.anim.newAction = 11;
        }
        this.handleKeyEvent();
        this.checkCamera();
        if (this.V[10] > 75) {
            GameMidlet.Instance_Game.Status_ShowLock();
            int n = this.V[11];
            this.V[11] = n + 1;
            if ((n & 1) == 0) {
                this.anim.newAction = 39;
            } else {
                this.anim.newAction = 40;
                this.V[11] = 0;
            }
            this.V[10] = 0;
        }
        if (this.actorReference != null && (this.actorReference.objType == 11 || this.actorReference.objType == 10)) {
            this.Rayman_doPlatform();
        }
        if (action == 9 || action == 8 || action == 7 || action == 10) {
            this.checkCeilingAir();
        }
        if (action != 27 && this.checkWall()) {
            this.dx = 0;
        }
        if (action == 27) {
            this.dy = 0;
            this.dx = 0;
        } else if (this.V[15] == 1 || this.checkClimb()) {
            switch (action) {
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    this.anim.newAction = 17;
                    break;
                }
            }
        } else if (this.canHangRoof()) {
            switch (action) {
                case 7: 
                case 8: 
                case 9: 
                case 11: {
                    this.anim.newAction = 30;
                }
            }
        } else {
            switch (action) {
                case 31: {
                    this.anim.newAction = 11;
                    this.y += 2048L;
                    break;
                }
                case 7: 
                case 8: {
                    if (!this.checkCeilingAir()) break;
                    this.anim.newAction = 11;
                }
            }
        }
        if (this.anim.newAction != 8 && this.anim.newAction != 7) {
            if (this.checkFloor()) {
                switch (action) {
                    case 9: 
                    case 10: 
                    case 11: {
                        if (this.bWasPHBStop) break;
                        this.anim.newAction = 12;
                    }
                }
            } else if (this.actorReference != null && (this.actorReference.objType == 11 || this.actorReference.objType == 10)) {
                switch (action) {
                    case 9: 
                    case 28: 
                    case 29: {
                        this.anim.newAction = 12;
                    }
                }
            } else {
                switch (action) {
                    case 0: 
                    case 2: 
                    case 4: 
                    case 5: {
                        this.anim.newAction = 11;
                        break;
                    }
                    case 9: {
                        if (this.canHangOnLedge() || this.V[7] != 0 || (this.V[6] = this.V[6] + 1) <= 25) break;
                        this.anim.newAction = 11;
                        this.V[0] = this.V[0] & 0xFFFFFFFD;
                        break;
                    }
                    case 10: 
                    case 11: {
                        if (!this.canHangOnLedge()) break;
                    }
                }
            }
        }
        if (this.anim.newAction == 28 || this.anim.newAction == 12 || this.anim.newAction == 30 || this.anim.newAction == 27 || this.anim.newAction == 7 || this.anim.newAction >= 17 && this.anim.newAction <= 22) {
            this.V[0] = this.V[0] | 2;
        }
        if (action != 33 && action != 32) {
            this.checkDamage();
        }
        if (action == 11 && (this.anim.oldAction == 2 || this.anim.oldAction == 0 || this.anim.oldAction == 5 || this.anim.oldAction == 5 || this.anim.oldAction == 4)) {
            if (this.mmodel_vX < 0) {
                this.mmodel_vX = (short)-512;
            } else if (this.mmodel_vX > 0) {
                this.mmodel_vX = (short)512;
            }
        }
        if (this.anim.curAction != this.anim.newAction) {
            this.anim.oldAction = this.anim.curAction;
            if (this.anim.curAction == 9) {
                // empty if block
            }
            switch (this.anim.newAction) {
                case 16: 
                case 25: 
                case 35: {
                    GameMidlet.Instance_Game.PlaySound(37, true, 255);
                    break;
                }
                case 9: {
                    GameMidlet.Instance_Game.PlaySound(41, true);
                    break;
                }
                case 11: {
                    if (this.anim.curAction == 7 || this.anim.curAction == 8) break;
                    this.V[16] = (int)(this.y >> 8);
                    if (this.mmodel_vX < 0) {
                        this.mmodel_vX = (short)-768;
                        break;
                    }
                    if (this.mmodel_vX <= 0) break;
                    this.mmodel_vX = (short)768;
                    break;
                }
                case 7: {
                    GameMidlet.Instance_Game.PlaySound(43, true);
                    break;
                }
                case 10: 
                case 13: 
                case 23: {
                    GameMidlet.Instance_Game.PlaySound(38, true);
                    break;
                }
                case 3: {
                    GameMidlet.Instance_Game.PlaySound(39, true);
                    break;
                }
            }
        }
    }

    void ai() {
        switch (this.objType) {
            case 15: {
                this.SeaUrchin_ai();
                break;
            }
            case 17: {
                this.Bomb_ai();
                break;
            }
            case 16: {
                this.Spike_ai();
                break;
            }
            case 0: {
                this.Rayman_ai();
                break;
            }
            case 1: {
                this.Fist_ai();
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 24: {
                this.Bonus_ai();
                break;
            }
            case 12: {
                this.Cage_ai();
                break;
            }
            case 6: {
                this.LevelSign_ai();
                break;
            }
            case 22: {
                this.Pirate_ai();
                break;
            }
            case 25: {
                this.Bullet_ai();
                break;
            }
            case 18: {
                this.Fly_ai();
                break;
            }
            case 19: {
                this.Tentacle_ai();
                break;
            }
            case 7: {
                this.LevelPost_ai();
                break;
            }
            case 10: 
            case 11: {
                this.Platform_ai();
            }
        }
    }

    public void Actor_Reset() {
        switch (this.objType) {
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: {
                this.x = this.m_lInitX;
                this.y = this.m_lInitY;
                this.anim.newAction = this.m_iInitAction;
                this.stateFlag = this.m_sInitStateFlag;
                if (this.m_iInitV != null) {
                    System.arraycopy(this.m_iInitV, 0, this.V, 0, this.V.length);
                }
                this.dx = 0;
                this.dy = 0;
                this.m_sPHBTableReferenceTileX = (short)-10;
                this.m_sPHBTableReferenceTileY = (short)-10;
                if (this.m_bPHBTable == null) break;
                int i = 0;
                while (i < this.m_bPHBTable.length) {
                    int j = 0;
                    while (j < this.m_bPHBTable[i].length) {
                        this.m_bPHBTable[i][j] = 0;
                        ++j;
                    }
                    ++i;
                }
                break;
            }
        }
        if (this.objType == 0) {
            if (Game.s_actorCheckpoint != null) {
                this.x = Game.s_actorCheckpoint.x;
                this.y = Game.s_actorCheckpoint.y;
                this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                this.xDirectionConfirmed = true;
            }
            this.xDirectionConfirmed = (this.stateFlag & 1) != 0;
            Game.pFist[0].anim.curAction = 0;
            Game.pFist[1].anim.curAction = 0;
            this.xDirectionConfirmationCounter = this.xDirectionConfirmed ? 2 : -2;
        }
    }

    void Actor_SetReferencePoint(int tileX, int tileY) {
        short offsetX = (short)(tileX - this.m_sPHBTableReferenceTileX);
        short offsetY = (short)(tileY - this.m_sPHBTableReferenceTileY);
        short lowRangeX = -this.m_sTableRefIndexX;
        int highRangeX = this.m_bPHBTable[0].length - 1 - this.m_sTableRefIndexX;
        short lowRangeY = -this.m_sTableRefIndexY;
        int highRangeY = this.m_bPHBTable.length - 1 - this.m_sTableRefIndexY;
        if (offsetX < 0) {
            if (offsetY < 0) {
                int arrayY = this.m_bPHBTable.length - 1;
                int i = tileY + highRangeY;
                while (i >= tileY + lowRangeY) {
                    int arrayX = this.m_bPHBTable[arrayY].length - 1;
                    int j = tileX + highRangeX;
                    while (j >= tileX + lowRangeX) {
                        this.m_bPHBTable[arrayY][arrayX] = this.Actor_GetPHB(j, i);
                        --arrayX;
                        --j;
                    }
                    --arrayY;
                    --i;
                }
            } else {
                int arrayY = 0;
                int i = tileY + lowRangeY;
                while (i <= tileY + highRangeY) {
                    int arrayX = this.m_bPHBTable[arrayY].length - 1;
                    int j = tileX + highRangeX;
                    while (j >= tileX + lowRangeX) {
                        this.m_bPHBTable[arrayY][arrayX] = this.Actor_GetPHB(j, i);
                        --arrayX;
                        --j;
                    }
                    ++arrayY;
                    ++i;
                }
            }
        } else if (offsetY < 0) {
            int arrayY = this.m_bPHBTable.length - 1;
            int i = tileY + highRangeY;
            while (i >= tileY + lowRangeY) {
                int arrayX = 0;
                int j = tileX + lowRangeX;
                while (j <= tileX + highRangeX) {
                    this.m_bPHBTable[arrayY][arrayX] = this.Actor_GetPHB(j, i);
                    ++arrayX;
                    ++j;
                }
                --arrayY;
                --i;
            }
        } else {
            int arrayY = 0;
            int i = tileY + lowRangeY;
            while (i <= tileY + highRangeY) {
                int arrayX = 0;
                int j = tileX + lowRangeX;
                while (j <= tileX + highRangeX) {
                    this.m_bPHBTable[arrayY][arrayX] = this.Actor_GetPHB(j, i);
                    ++arrayX;
                    ++j;
                }
                ++arrayY;
                ++i;
            }
        }
        this.m_sPHBTableReferenceTileX = (short)tileX;
        this.m_sPHBTableReferenceTileY = (short)tileY;
    }

    byte Actor_GetPHB(int tileX, int tileY) {
        if (this.m_bPHBTable != null && tileX >= this.m_sPHBTableReferenceTileX + -this.m_sTableRefIndexX && tileX <= this.m_sPHBTableReferenceTileX + (this.m_bPHBTable[0].length - 1 - this.m_sTableRefIndexX) && tileY >= this.m_sPHBTableReferenceTileY + -this.m_sTableRefIndexY && tileY <= this.m_sPHBTableReferenceTileY + (this.m_bPHBTable.length - 1 - this.m_sTableRefIndexY)) {
            return this.m_bPHBTable[tileY - this.m_sPHBTableReferenceTileY + this.m_sTableRefIndexY][tileX - this.m_sPHBTableReferenceTileX + this.m_sTableRefIndexX];
        }
        return GameMidlet.Instance_Game.PF_getPHBI(tileX, tileY);
    }

    boolean Actor_Death() {
        if (this.objType != 7) {
            this.stateFlag = (short)(this.stateFlag | 8);
        } else if (Game.s_iLeftToDie != 1) {
            return false;
        }
        if ((this.stateFlag & 2) != 0) {
            --Game.s_iLeftToDie;
        }
        return true;
    }

    void checkCamera() {
        if (this.anim.curAction != 8 && this.anim.curAction != 7 && (this.anim.curAction != 11 && this.anim.curAction != 10 || this.y >> 8 > (long)this.V[16]) && (this.anim.curAction != 9 || this.V[7] == -1 || this.y >> 8 > (long)this.V[16])) {
            if (this.yDirectionConfirmed == 0) {
                if (this.dy < 0) {
                    --this.yDirectionConfirmationCounter;
                } else if (this.dy > 0) {
                    ++this.yDirectionConfirmationCounter;
                }
                if (this.yDirectionConfirmationCounter > 4) {
                    this.yDirectionConfirmationCounter += 2;
                } else if (this.yDirectionConfirmationCounter < -4) {
                    this.yDirectionConfirmed = -1;
                }
            } else if (this.yDirectionConfirmed == 1) {
                if (this.dy < 0) {
                    --this.yDirectionConfirmationCounter;
                }
                if (this.yDirectionConfirmationCounter < -1) {
                    this.yDirectionConfirmed = -1;
                }
            } else if (this.yDirectionConfirmed == -1) {
                if (this.dy > 0) {
                    ++this.yDirectionConfirmationCounter;
                }
                if (this.yDirectionConfirmationCounter > 1) {
                    this.yDirectionConfirmed = 1;
                }
            }
        }
        if (this.xDirectionConfirmed) {
            if (this.dx < 0 || this.actorReference != null && (this.actorReference.objType == 11 || this.actorReference.objType == 10) && this.actorReference.dx < 0) {
                --this.xDirectionConfirmationCounter;
            }
            if (this.xDirectionConfirmationCounter < -1) {
                this.xDirectionConfirmed = false;
            }
        } else {
            if (this.dx > 0 || this.actorReference != null && (this.actorReference.objType == 11 || this.actorReference.objType == 10) && this.actorReference.dx > 0) {
                ++this.xDirectionConfirmationCounter;
            }
            if (this.xDirectionConfirmationCounter > 1) {
                this.xDirectionConfirmed = true;
            }
        }
        if (this.anim.curAction == 16 || this.anim.curAction == 35 || this.anim.curAction == 34 || this.anim.curAction == 10 || this.anim.curAction == 25 || this.anim.curAction == 24 || this.anim.curAction == 23) {
            this.xDirectionConfirmed = (this.stateFlag & 1) != 0;
            this.xDirectionConfirmationCounter = this.xDirectionConfirmed ? 4 : -4;
        }
        int f = 0;
        while (f < 2) {
            if (Game.pFist[f].anim.curAction != 0) {
                if (Game.pFist[f].x < this.x) {
                    this.xDirectionConfirmed = false;
                    this.xDirectionConfirmationCounter = -4;
                } else if (Game.pFist[f].x > this.x) {
                    this.xDirectionConfirmed = true;
                    this.xDirectionConfirmationCounter = 4;
                }
            }
            ++f;
        }
    }
}

